#!/bin/bash
#
# Cron-driven bot to start a udptap cables or switch unless already up

UDPTAP=/usr/local/sbin/udptap

function start-switch() {
    . $1
    exec $UDPTAP $VERBOSE -4 $PORT ${VPN[@]}
}

function start-cable() {
    . $1
    ip link show dev $TAP > /dev/null || \
	{ ip tuntap add $TAP mode tap ; ip link set dev $TAP up ; }
    [ -z "$MAC" ] || ifconfig $TAP | grep -q "ether $MAC" || \
	ifconfig $TAP hw ether $MAC
    [ -z "$IP" ] || ip addr show dev $TAP | grep -q $IP || \
	ip addr add $IP dev $TAP
    [ -z "$BR" ] || brctl show | grep -q $TAP || \
	brctl addif $BR $TAP
    exec $UDPTAP $VERBOSE -4 ${OPTIONS[@]} -t $TAP $PORT ${VPN[@]}
}

for CABLE in $* ; do
    CONF=/etc/udptap/conf.d/$CABLE.conf
    eval $(grep ^PORT= $CONF)
    lsof -i :$PORT > /dev/null && continue
    eval $(grep ^TAP= $CONF)
    LOG=/tmp/$CABLE.log
    if [ -z "$TAP" ] ; then
	( start-switch $CONF < /dev/null >> $LOG 2>&1 & )
    else
	( start-cable $CONF /dev/null >> $LOG 2>&1 & )
    fi
done
